// PS.Data.iSeries driver for iSeries Access
//  2001-2004 Peter Sawatzki (peter@sawatzki.de)
//
// driver for earlier versions (pre D9)
//
using System;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;
using System.Text;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Data;
using Borland.Data.Common;
using Borland.Data.Schema;
using System.Windows.Forms;

[assembly: AssemblyTitle("PS Data Providers for .NET")]
[assembly: AssemblyDescription("BDP - iSeries")]
[assembly: AssemblyCompany("Peter Sawatzki")]
[assembly: AssemblyProduct("PS Data Providers for .NET (BDP.NET)")]
[assembly: AssemblyCopyright("Peter Sawatzki")]
#if version1200
  [assembly: AssemblyVersion("1.2.0.0")]
#elif version1500
  [assembly: AssemblyVersion("1.5.0.0")]
#elif version1510
  [assembly: AssemblyVersion("1.5.1.0")]
#else
  [assembly: AssemblyVersion("2.0.0.0")]
#endif
[assembly: AssemblyKeyFileAttribute("ps.key")]

//          MessageBox.Show(Convert.ToString(eMetaProp), "MetaData.GETProperty", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);

namespace PS.Data.iSeries
{

public class BdpiSeries {
  const string bdpiSeries = "dbexpca400.dll";
  // Connection related
  [DllImportAttribute(bdpiSeries)] public static extern int ConInit(string szVendorLib, string szResource);
  [DllImportAttribute(bdpiSeries)] public static extern int ConExit();
  [DllImportAttribute(bdpiSeries)] public static extern int ConAlloc(out int Handle);
  [DllImportAttribute(bdpiSeries)] public static extern int ConFree(int Handle);
  [DllImportAttribute(bdpiSeries)] public static extern int ConConnect(int Handle, string szDatabase, string szUser, string szPasswd);
  [DllImportAttribute(bdpiSeries)] public static extern int ConDisConnect(int Handle);
  [DllImportAttribute(bdpiSeries)] public static extern int ConSetOptions(int Handle, string szValue);
  [DllImportAttribute(bdpiSeries)] public static extern int ConTransact(int Handle, int mode, int ilTransID);
  [DllImportAttribute(bdpiSeries)] public static extern int ConGetConnError(int Handle, StringBuilder Error, int Len);
  [DllImportAttribute(bdpiSeries)] public static extern int ConGetCommand(int Handle, out int Command);
  [DllImportAttribute(bdpiSeries)] public static extern int ConGetMetadata(int Handle, out int MetaHandle);

  // Command related
  [DllImportAttribute(bdpiSeries)] public static extern int CmdPrepare(int Handle, string szSQL, int ParamCount, out int ColCount);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdSetOption(int Handle, int Option, int ulValue);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdExecute(int Handle, out int CursorHandle);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdRowsAffected(int Handle, out int lRowsAffected);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdGetError(int Handle, StringBuilder Error, int Len);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdSetParameterBool(int Handle, short uParamNumber, short uChildPos, ParameterDirection eParamDir, BdpType uType, BdpType subType, int lMaxPrecision, int lMaxScale, int Length, bool Value, bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdSetParameterInt16(int Handle, short uParamNumber, short uChildPos, ParameterDirection eParamDir, BdpType uType, BdpType subType, int lMaxPrecision, int lMaxScale, int Length, short Value, bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdSetParameterInt32(int Handle, short uParamNumber, short uChildPos, ParameterDirection eParamDir, BdpType uType, BdpType subType, int lMaxPrecision, int lMaxScale, int Length, int Value, bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdSetParameterInt64(int Handle, short uParamNumber, short uChildPos, ParameterDirection eParamDir, BdpType uType, BdpType subType, int lMaxPrecision, int lMaxScale, int Length, long Value, bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdSetParameterFloat(int Handle, short uParamNumber, short uChildPos, ParameterDirection eParamDir, BdpType uType, BdpType subType, int lMaxPrecision, int lMaxScale, int Length, float Value, bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdSetParameterDouble(int Handle, short uParamNumber, short uChildPos, ParameterDirection eParamDir, BdpType uType, BdpType subType, int lMaxPrecision, int lMaxScale, int Length, double Value, bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdSetParameterString(int Handle, short uParamNumber, short uChildPos, ParameterDirection eParamDir, BdpType uType, BdpType subType, int lMaxPrecision, int lMaxScale, int Length, string Value, bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdSetParameterDecimal(int Handle, short uParamNumber, short uChildPos, ParameterDirection eParamDir, BdpType uType, BdpType subType, int lMaxPrecision, int lMaxScale, int Length, string Value, bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdGetParameterBool(int Handle, short uParamNumber, short uChildPos, out object Value, out bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdGetParameterInt16(int Handle, short uParamNumber, short uChildPos, out object Value, out bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdGetParameterInt32(int Handle, short uParamNumber, short uChildPos, out object Value, out bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdGetParameterInt64(int Handle, short uParamNumber, short uChildPos, out object Value, out bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdGetParameterFloat(int Handle, short uParamNumber, short uChildPos, out object Value, out bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdGetParameterDouble(int Handle, short uParamNumber, short uChildPos, out object Value, out bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdGetParameterString(int Handle, short uParamNumber, short uChildPos, out object Value, out bool bIsNull);
  [DllImportAttribute(bdpiSeries)] public static extern int CmdGetParameterDecimal(int Handle, short uParamNumber, short uChildPos, out object Value, out bool bIsNull);

  // Cursor related
  [DllImportAttribute(bdpiSeries)] public static extern int CurNext(int Handle);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetColumnName(int Handle, int ColumnNumber, StringBuilder Value, int Len);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetColumnTypeName(int Handle, int ColumnNumber, StringBuilder Value, int Len);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetColumnType(int Handle, int ColumnNumber, out short uType, out short uSubType);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetColumnLength(int Handle, int ColumnNumber, out int ulLength);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetIsNull(int Handle, int ColumnNumber, out int iInd);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetInt16(int Handle, int ColumnNumber, out short Data, out int iInd);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetInt32(int Handle, int ColumnNumber, out int Data, out int iInd);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetInt64(int Handle, int ColumnNumber, out long Data, out int iInd);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetDouble(int Handle, int ColumnNumber, out double Data, out int iInd);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetFloat(int Handle, int ColumnNumber, out float Data, out int iInd);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetString(int Handle, int ColumnNumber, StringBuilder Data, out int iInd);
  [DllImportAttribute(bdpiSeries)] public static extern int CurGetDecimalAsString(int Handle, int ColumnNumber, StringBuilder Data, out int iInd);

  // Metadata related
  [DllImportAttribute(bdpiSeries)] public static extern int MetFree(int Handle);
  [DllImportAttribute(bdpiSeries)] public static extern int MetOpenSchema(int Handle, MetaDataType eMetaDataType, string CatalogName, string OwnerName, string ObjectName, string ColName, int ObjType);
  [DllImportAttribute(bdpiSeries)] public static extern int MetCloseSchema(int Handle);
  [DllImportAttribute(bdpiSeries)] public static extern int MetNext(int Handle);
  [DllImportAttribute(bdpiSeries)] public static extern int MetGetInt32(int Handle, int ColumnNumber, out int Data, out int iInd);
  [DllImportAttribute(bdpiSeries)] public static extern int MetGetString(int Handle, int ColumnNumber, StringBuilder Data, out int iInd);
  [DllImportAttribute(bdpiSeries)] public static extern int MetGetType(int Handle, out short uType, out short uSubType, out int iInd);

}

[Serializable()]
public class iSeriesConnectionString : BdpConnectionString
{ new protected const string SProvider = "ISERIES";
  protected const string AssemblyName = "PS.Data.iSeries, Version=2.0.0.0, Culture=neutral, PublicKeyToken=df047b757d3f379a";
  protected const string VendorClientName = "cwbdb.dll";
  protected const string SRole      = "Role";
  protected const string SServerCharset = "ServerCharset";
  protected const string STrace     = "Trace";
  protected const string STrimChar  = "TrimChar";
  protected const string SSysNaming = "SysNaming";       // SysNaming ("/") vs. DB2 naming (".")
  protected const string SLibs      = "Libs";            // search library list for metadata
  protected const string SLimitMD   = "limitmd";         // limit metadata retrieval
  protected const string SLOBThreshold = "lobthreshold"; // threshold for returning inline LOBs
  protected const string SDescribe  = "describe";        // set column name types: 0=ALIAS_NAMES (default), 1=NAMES_ONLY, 2=LABELS
  protected const string SSortType  = "sorttype";        // specifies how the server sorts records before sending them to the client
  protected const string SSortTable = "sorttable";       // if sorttype is 1 or 2, specifies a 3-character language id to use for selection
  protected const string SSortLib   = "sortlib";         // Specifies the library of a sort sequence table stored on the iSeries server

  public iSeriesConnectionString()
  { SetProvider(SProvider);
    DefaultAssembly = AssemblyName;
    DefaultVendorClient = VendorClientName;
    Database = "*";
    UserName = "";
    Password = "";
    Role = "";
    ServerCharset = "";
    Trace = 0;
    TrimChar = false;
    SysNaming = false;
    Libs = "";
    LimitMD = 300;
    LOBThreshold = 16384;
    Describe = 0;
    SortType = -1;
    SortTable = "";
    SortLib = "";
  }


  [CategoryAttribute("Options")]
  [DefaultValueAttribute("")]
  public string Role
  { get {return OptionsDictionary[SRole];}
    set {       OptionsDictionary[SRole] = value; }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute("")]
  public string ServerCharset
  { get {return OptionsDictionary[SServerCharset];}
    set {       OptionsDictionary[SServerCharset] = value; }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute(0)]
  public int Trace
  { get {return Convert.ToInt32(OptionsDictionary[STrace]); }
    set {       OptionsDictionary[STrace] = value.ToString(); }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute(false)]
  public bool TrimChar
  { get {return Convert.ToBoolean(OptionsDictionary[STrimChar]); }
    set {       OptionsDictionary[STrimChar] = value.ToString(); }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute(false)]
  public bool SysNaming
  { get {return Convert.ToBoolean(OptionsDictionary[SSysNaming]); }
    set {       OptionsDictionary[SSysNaming] = value.ToString(); }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute("")]
  public string Libs
  { get {return OptionsDictionary[SLibs];}
    set {       OptionsDictionary[SLibs] = value; }
  }


  [CategoryAttribute("Options")]
  [DefaultValueAttribute(300)]
  public int LimitMD
  { get {return Convert.ToInt32(OptionsDictionary[SLimitMD]); }
    set {       OptionsDictionary[SLimitMD] = value.ToString(); }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute(16384)]
  public int LOBThreshold
  { get {return Convert.ToInt32(OptionsDictionary[SLOBThreshold]); }
    set {       OptionsDictionary[SLOBThreshold] = value.ToString(); }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute(0)]
  public int Describe
  { get {return Convert.ToInt32(OptionsDictionary[SDescribe]); }
    set {       OptionsDictionary[SDescribe] = value.ToString(); }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute(-1)]
  public int SortType
  { get {return Convert.ToInt32(OptionsDictionary[SSortType]); }
    set {       OptionsDictionary[SSortType] = value.ToString(); }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute("")]
  public string SortTable
  { get {return OptionsDictionary[SSortTable];}
    set {       OptionsDictionary[SSortTable] = value; }
  }

  [CategoryAttribute("Options")]
  [DefaultValueAttribute("")]
  public string SortLib
  { get {return OptionsDictionary[SSortLib];}
    set {       OptionsDictionary[SSortLib] = value; }
  }

}

//----------------------------------------------------------------------
public class iSeriesConnection: ISQLConnection
{ private static short iDriverInit;
  private string FSchemaName = "";
  private bool FQuoteObjects = false;
  private StringBuilder FErrorText = null;
  public int ConnHandle;

  public iSeriesConnection()
  { FErrorText = new StringBuilder(4096);
    if (iDriverInit == 0)
      if (BdpiSeries.ConInit("cwbdb.dll", "")!=0)
        throw new BdpException("BdpiSeries.ConInit failed");
    iDriverInit++;
    if (BdpiSeries.ConAlloc(out ConnHandle)!=0)
      throw new BdpException("BdpiSeries.ConAlloc failed");
  }

  ~iSeriesConnection()
  { iDriverInit--;
    if (iDriverInit == 0)
      BdpiSeries.ConExit();
  }

  private void SplitPrivate (string ConnOptions)
  { //foreach (string s in ConnOptions.Split(new char[] {';'})) {
    foreach (string s in ConnOptions.Split(';')) {
      if ( string.Compare(s.Trim(), 0, "QuoteObjects", 0, 12, true)==0 &&
           s.ToLower().IndexOf("true")!=-1 )
        FQuoteObjects = true;
    }
  }

  public virtual int SetOptions(string ConnOptions)
  { SplitPrivate(ConnOptions);
    return BdpiSeries.ConSetOptions(ConnHandle, ConnOptions);
  }

  public virtual int Connect(string szDatabase, string szUser, string szPasswd, string szHost)
  { return BdpiSeries.ConConnect(ConnHandle, szDatabase, szUser, szPasswd); }

  public virtual int Disconnect()
  { return BdpiSeries.ConDisConnect(ConnHandle); }

  public virtual int FreeConnect()
  { return BdpiSeries.ConFree(ConnHandle); }

  public virtual int ChangeDatabase(string szDatabase, string szUser, string szPasswd, bool bConnected)
  { int res = 0;
    if (bConnected)
      res = Disconnect();
    if (res == 0)
      res = Connect(szDatabase, szUser, szPasswd, "");
    return res;
  }

  public virtual ISQLCommand GetSQLCommand()
  { return new iSeriesCommand(this); }

  public virtual ISQLMetaData GetMetaData()
  { ISQLMetaData iSQLMetaData = new iSeriesMetaData(this);
    iSQLMetaData.SetProperty(MetaDataProps.SchemaName, FSchemaName);
    iSQLMetaData.SetProperty(MetaDataProps.QuoteObjects, FQuoteObjects);
    return iSQLMetaData;
  }

  public virtual ISQLResolver GetResolver()
  { ISQLResolver resolver = new iSeriesResolver(this);
    if (FQuoteObjects==true) {
      resolver.QuotePrefix = "\"";
      resolver.QuoteSuffix = "\"";
    }
    return resolver;
  }

  public virtual int BeginTransaction(int ilTransID, int IsolationLevel)
  { return BdpiSeries.ConTransact(ConnHandle, 1, ilTransID); }

  // this one is for C#Builder
  public virtual int BeginTransaction(int ilTransID, short IsolationLevel)
  { return BdpiSeries.ConTransact(ConnHandle, 1, ilTransID); }

  public virtual int Commit(int ilTransID)
  { return BdpiSeries.ConTransact(ConnHandle, 2, ilTransID); }

  public virtual int Rollback(int ilTransID)
  { return BdpiSeries.ConTransact(ConnHandle, 5, ilTransID); }

  public virtual int GetErrorMessage(ref StringBuilder ErrorMessage)
  { int res = BdpiSeries.ConGetConnError(ConnHandle, FErrorText, FErrorText.Capacity);
    if (res==0)
      ErrorMessage.Insert(0, FErrorText.ToString());
    return res;
  }

  public virtual void SetProperty(ConnectionProps eConnProp, object Value)
  { if (eConnProp==ConnectionProps.SchemaName) {
      FSchemaName = (String) Value;
    }
  }

  public virtual void GetProperty(ConnectionProps eConnProp, out object Value)
  { if (eConnProp == ConnectionProps.SchemaName)
      Value = FSchemaName;
    else
      Value = null;
  }

}

//----------------------------------------------------------------------
public class iSeriesCommand: ISQLCommand
{ private int CommHandle;
  private iSeriesConnection FiSeriesConn;
  private int FColCount;
  private StringBuilder FErrorText;

  internal int GetColCount() { return FColCount; }

  public iSeriesCommand(iSeriesConnection iSeriesConn)
  { FColCount = 0;
    FErrorText = new StringBuilder(4096);
    FiSeriesConn = iSeriesConn;
    if (BdpiSeries.ConGetCommand(FiSeriesConn.ConnHandle, out CommHandle)!=0)
      throw new BdpException(BdpResources.GetString("CommandFailed"));
  }

  public virtual int Prepare(string szSQL, short iParamCount)
  { return BdpiSeries.CmdPrepare(CommHandle, szSQL, iParamCount, out FColCount); }

  public virtual int PrepareProc(string szSQL, short iParamCount)
  { int res = Prepare(szSQL, iParamCount);
    if (res==0)
      res = BdpiSeries.CmdSetOption(CommHandle, (int) BdpOptions.xoSTOREDPROCEDURE, 1);
    return res;
  }

  public virtual int GetStoredProcedureSQL(StringBuilder SQL, ArrayList ParamList)
  { SQL.Insert(0, "CALL ");
    if (ParamList.Count > 0) {
      SQL.Append("(?");
      for (int k = 1; k < ParamList.Count; k++)
        SQL.Append(",?");
      SQL.Append(")");
    }
    return 0;
  }

  public virtual int Execute(out ISQLCursor SQLCur, ref short nResultCols)
  { nResultCols = (short) FColCount;
    SQLCur = new iSeriesCursor(this);
    return BdpiSeries.CmdExecute(CommHandle, out ((iSeriesCursor) SQLCur).CursorHandle);
  }

  public virtual int GetRowsAffected(ref int lRowsAffected)
  { return BdpiSeries.CmdRowsAffected(CommHandle, out lRowsAffected); }

  public virtual int GetErrorMessage(ref StringBuilder ErrorMessage)
  { int res = BdpiSeries.CmdGetError(CommHandle, FErrorText, FErrorText.Capacity);
    if (res==0)
      ErrorMessage.Insert(0, FErrorText.ToString());
    return res;
  }

  public virtual int SetOptions(string[] CommOptions)
  { return 0;
  }

  public virtual int SetParameter(short uParamNumber, short uChildPos, ParameterDirection eParamDir, BdpType uType, BdpType subType, int lMaxPrecision, int lMaxScale, int Length, object Value, bool bIsNull)
  { switch (uType) {
    case (BdpType)1: return BdpiSeries.CmdSetParameterString (CommHandle, uParamNumber, uChildPos, eParamDir, uType, subType, lMaxPrecision, lMaxScale, Length, Convert.ToString(Value), bIsNull);
    case (BdpType)2: return BdpiSeries.CmdSetParameterBool   (CommHandle, uParamNumber, uChildPos, eParamDir, uType, subType, lMaxPrecision, lMaxScale, Length, Convert.ToBoolean(Value), bIsNull);
    case (BdpType)3: return BdpiSeries.CmdSetParameterInt16  (CommHandle, uParamNumber, uChildPos, eParamDir, uType, subType, lMaxPrecision, lMaxScale, Length, Convert.ToInt16(Value), bIsNull);
    case (BdpType)4: return BdpiSeries.CmdSetParameterInt32  (CommHandle, uParamNumber, uChildPos, eParamDir, uType, subType, lMaxPrecision, lMaxScale, Length, Convert.ToInt32(Value), bIsNull);
    case (BdpType)5: return BdpiSeries.CmdSetParameterInt64  (CommHandle, uParamNumber, uChildPos, eParamDir, uType, subType, lMaxPrecision, lMaxScale, Length, Convert.ToInt64(Value), bIsNull);
    case (BdpType)6: return BdpiSeries.CmdSetParameterFloat  (CommHandle, uParamNumber, uChildPos, eParamDir, uType, subType, lMaxPrecision, lMaxScale, Length, Convert.ToSingle(Value), bIsNull);
    case (BdpType)7: return BdpiSeries.CmdSetParameterDouble (CommHandle, uParamNumber, uChildPos, eParamDir, uType, subType, lMaxPrecision, lMaxScale, Length, Convert.ToDouble(Value), bIsNull);
    case (BdpType)8: return BdpiSeries.CmdSetParameterDecimal(CommHandle, uParamNumber, uChildPos, eParamDir, uType, subType, lMaxPrecision, lMaxScale, Length, Convert.ToString(Value), bIsNull);
    default:  throw new BdpException(BdpResources.GetString("InvalidBdpType"));
    /*  case (BdpType)11: i = putTimeStamp(ref param1, Value, Length);
        case (BdpType)9:  i = putDate(ref param1, Value, Length);
        case (BdpType)10: i = putTime(ref param1, Value, Length);
        case (BdpType)14: i = putBlob(ref param1, Value, Length);
        case (BdpType)12:
        case (BdpType)13:i = putBytes(ref param1, Value, Length);
   */
    }
  }

  public virtual int GetParameter(short uParamNumber, short uChildPos, ref object Value, ref bool bIsNull)
  { Type type = Value.GetType();
    int res = 1;
    if       (type==typeof(String))                         res = BdpiSeries.CmdGetParameterString(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
    else if ((type==typeof(Int16))||(type==typeof(UInt16))) res = BdpiSeries.CmdGetParameterInt16(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
    else if ((type==typeof(Int32))||(type==typeof(UInt32))) res = BdpiSeries.CmdGetParameterInt32(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
    else if ((type==typeof(Int64))||(type==typeof(UInt64))) res = BdpiSeries.CmdGetParameterInt64(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
    else if (type==typeof(Boolean))                         res = BdpiSeries.CmdGetParameterBool(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
    else if (type==typeof(Single))                          res = BdpiSeries.CmdGetParameterFloat(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
    else if (type==typeof(Double))                          res = BdpiSeries.CmdGetParameterDouble(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
    else if (type==typeof(Decimal))                         res = BdpiSeries.CmdGetParameterDecimal(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
/*    else if ((type==typeof(Char))||(type==typeof(Byte))||(type==typeof(SByte))) res = BdpiSeries.CmdGetParameterString(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
    else if ((type==typeof(Char))||(type==typeof(Byte))||(type==typeof(SByte))) res = BdpiSeries.CmdGetParameterDecimal(CommHandle, uParamNumber, uChildPos, out Value, out bIsNull);
 */
    return res;
  }

/*
                case 11:
                    BdpTimeStamp bdpTimeStamp1 = new BdpTimeStamp(0, 0, 0, 0, 0, 0, 0);
                    i = BdpiSeries.SQLGetTimeStamp(param.pData.ToPointer(), &bdpTimeStamp1);
                    if (i == 0)
                    {
                        DateTime dateTime1 = new DateTime(bdpTimeStamp1.year, bdpTimeStamp1.month, bdpTimeStamp1.day, bdpTimeStamp1.hour, bdpTimeStamp1.minute, bdpTimeStamp1.second);
                        Value = dateTime1;
                    }
                    break;

                case 9:
                    BdpTimeStamp bdpTimeStamp2 = new BdpTimeStamp(0, 0, 0, 0, 0, 0, 0);
                    i = BdpiSeries.SQLGetDate(param.pData.ToPointer(), &bdpTimeStamp2);
                    if (i == 0)
                    {
                        DateTime dateTime2 = new DateTime(bdpTimeStamp2.year, bdpTimeStamp2.month, bdpTimeStamp2.day, bdpTimeStamp2.hour, bdpTimeStamp2.minute, bdpTimeStamp2.second);
                        Value = dateTime2;
                    }
                    break;

                case 10:
                    BdpTimeStamp bdpTimeStamp3 = new BdpTimeStamp(0, 0, 0, 0, 0, 0, 0);
                    i = BdpiSeries.SQLGetTime(param.pData.ToPointer(), &bdpTimeStamp3);
                    if (i == 0)
                    {
                        DateTime dateTime3 = new DateTime(bdpTimeStamp3.year, bdpTimeStamp3.month, bdpTimeStamp3.day, bdpTimeStamp3.hour, bdpTimeStamp3.minute, bdpTimeStamp3.second);
                        Value = dateTime3;
                    }
                    break;

                case 14:
                    int k = 0;
                    byte* b8 = param.pData.ToPointer();
                    i = BdpiSeries.SQLGetBlobLength(FiSeriesConn.getHdbc, b8, &k);
                    if (i == 0 && k > 0)
                    {
                        ref byte b9;

                        byte[] bs = new byte[k];
                        fixed (b9 = &bs[0])
                        {
                            i = BdpiSeries.SQLGetBlob(FiSeriesConn.getHdbc, b8, (IntPtr)b9, k);
                        }
                        Value = Encoding.Default.GetString(bs);
                    }
                    break;
                }
            }
            return i;
          */

        public virtual int Close()
        {
            int i = 0;
           /*
            if (m_pRecordBuffer != IntPtr.Zero)
            {
                Marshal.FreeHGlobal(m_pRecordBuffer);
                m_pRecordBuffer = IntPtr.Zero;
            }
            i = BdpiSeries.ConFreeStatement(m_hstmt, 0);
            */
            return i;
        }

        public virtual int Release()
        {
            int i = 0;
            /*
            if (m_hstmt != (System.UIntPtr)0)
            {
                i = BdpiSeries.ConFreeStatement(m_hstmt, 1);
                if (i == 0)
                {
                    m_hstmt = (System.UIntPtr)0;
                }
            }
            */
            return i;
        }

    }


//----------------------------------------------------------------------
public class iSeriesCursor: ISQLCursor
{ public int CursorHandle;
  private iSeriesCommand FiSeriesComm;
  private StringBuilder Fsb;

  public iSeriesCursor(iSeriesCommand iSeriesComm)
  { FiSeriesComm = iSeriesComm;
    Fsb = new StringBuilder(4096);
  }

  public virtual int GetRowsAffected(ref int lRowsAffected)
  { return FiSeriesComm.GetRowsAffected(ref lRowsAffected); }

  public virtual int Next()
  { return BdpiSeries.CurNext(CursorHandle); }

  public virtual int GetNextResult(out ISQLCursor SQLCur, ref short nResultCols)
  { SQLCur = null;
    return -1;
  }

  public virtual int Release()
  { return FiSeriesComm.Close(); }

  public virtual short GetColumnCount()
  { return (short) FiSeriesComm.GetColCount(); }

  public virtual int GetErrorMessage(ref StringBuilder ErrorMessage)
  { return FiSeriesComm.GetErrorMessage(ref ErrorMessage); }

  public virtual int GetColumnName(short uCol, ref string szColName)
  { int res = BdpiSeries.CurGetColumnName(CursorHandle, uCol+1, Fsb, Fsb.Capacity);
    if (res==0) szColName = Fsb.ToString();
    return res;
  }

  public virtual int GetColumnTypeName(short uCol, ref string szTypeName)
  { int res = BdpiSeries.CurGetColumnTypeName(CursorHandle, uCol+1, Fsb, Fsb.Capacity);
    if (res==0) szTypeName = Fsb.ToString();
    return res;
  }

  public virtual int GetColumnType(short uCol, ref short uType, ref short uSubType)
  { return BdpiSeries.CurGetColumnType(CursorHandle, uCol+1, out uType, out uSubType); }

  public virtual int GetColumnLength(short uCol, ref int ulLength)
  { return BdpiSeries.CurGetColumnLength(CursorHandle, uCol+1, out ulLength); }

  public virtual int GetIsNull(short uColumn, ref int iInd)
  { return BdpiSeries.CurGetColumnLength(CursorHandle, uColumn+1, out iInd); }

  public virtual int GetShort(short uColumn, ref short Data, ref int iInd)
  { return BdpiSeries.CurGetInt16(CursorHandle, uColumn+1, out Data, out iInd); }

  public virtual int GetLong(short uColumn, ref int Data, ref int iInd)
  { return BdpiSeries.CurGetInt32(CursorHandle, uColumn+1, out Data, out iInd); }

  public virtual int GetInt64(short uColumn, ref long Data, ref int iInd)
  { return BdpiSeries.CurGetInt64(CursorHandle, uColumn+1, out Data, out iInd); }

  public virtual int GetGuid(short uColumn, ref Guid Data, ref int iInd)
  { return 0; }

  public virtual int GetDouble(short uColumn, ref double Data, ref int iInd)
  { return BdpiSeries.CurGetDouble(CursorHandle, uColumn+1, out Data, out iInd); }

  public virtual int GetFloat(short uColumn, ref float Data, ref int iInd)
  { return BdpiSeries.CurGetFloat(CursorHandle, uColumn+1, out Data, out iInd); }

  public virtual int GetString(short uColumn, ref StringBuilder Data, ref int iInd)
  { return BdpiSeries.CurGetString(CursorHandle, uColumn+1, Data, out iInd); }

  public int GetString(short uColumn, ref string Data, ref int iInd)
  { int res = BdpiSeries.CurGetString(CursorHandle, uColumn+1, Fsb, out iInd);
    if (res==0) Data = Fsb.ToString();
    return res;
  }

  public int GetByte(short uColumn, ref byte Data, ref int iInd)
  { return 0; }

  public int GetChar(short uColumn, ref char Data, ref int iInd)
  { return 0; }

  public virtual int GetDecimalAsString(short uColumn, StringBuilder Data, ref int iInd)
  { return BdpiSeries.CurGetDecimalAsString(CursorHandle, uColumn+1, Data, out iInd); }

  public virtual int GetTimeStamp(short uColumn, ref DateTime Data, ref int iInd)
        {
            int i = 0;
            //byte[] bs = null;
            // Column column = null;
            //BdpTimeStamp bdpTimeStamp1 = new BdpTimeStamp(0, 0, 0, 0, 0, 0, 0);
            //int j = 0;
            //iInd = 0;
            /* i = FiSeriesComm.getColumn(uColumn, out column);
            if (i == 0 && column != null)
            {
                bs = FiSeriesComm.getRecordBuffer();
                if (bs != null)
                {
                    ref byte b1;

                    fixed (b1 = &bs[(System.UIntPtr)column.uNullOffset])
                    {
                        j = *((IntPtr)b1);
                    }
                    if (j != -1)
                    {
                        ref byte b2;

                        ref byte b3;

                        ref byte b4;

                        BdpTimeStamp* bdpTimeStamp2 = &bdpTimeStamp1;
                        iInd = 0;
                        switch (column.uLogType)
                        {
                        case 11:
                            fixed (b2 = &bs[(System.UIntPtr)column.uOffset])
                            {
                                i = BdpiSeries.SQLGetTimeStamp((IntPtr)b2, bdpTimeStamp2);
                            }
                            break;

                        case 9:
                            fixed (b3 = &bs[(System.UIntPtr)column.uOffset])
                            {
                                i = BdpiSeries.SQLGetDate((IntPtr)b3, bdpTimeStamp2);
                            }
                            break;

                        case 10:
                            fixed (b4 = &bs[(System.UIntPtr)column.uOffset])
                            {
                                i = BdpiSeries.SQLGetTime((IntPtr)b4, bdpTimeStamp2);
                            }
                            break;
                        }
                        if (i == 0)
                        {
                            try
                            {
                                DateTime dateTime = new DateTime(bdpTimeStamp1.year, bdpTimeStamp1.month, bdpTimeStamp1.day, bdpTimeStamp1.hour, bdpTimeStamp1.minute, bdpTimeStamp1.second);
                                Data = dateTime;
                            }
                            catch (ArgumentOutOfRangeException)
                            {
                            }
                        }
                    }
                    else
                    {
                        iInd = 1;
                    }
                }
            }
            */
            return i;
        }

        public virtual int GetBlobSize(short uColumn, ref long lBlobSize, ref int iInd)
        {
            int i = 0;
            //byte[] bs = null;
            // Column column = null;
            //int j = 0;
            //void* local = (System.UIntPtr)0;
            //int k = 0;
            //iInd = 0;
            /* i = FiSeriesComm.getColumn(uColumn, out column);
            if (i == 0 && column != null)
            {
                bs = FiSeriesComm.getRecordBuffer();
                local = FiSeriesComm.getDbHandle();
                if (bs != null)
                {
                    ref byte b1;

                    fixed (b1 = &bs[(System.UIntPtr)column.uNullOffset])
                    {
                        j = *((IntPtr)b1);
                    }
                    if (j != -1)
                    {
                        ref byte b2;

                        iInd = 0;
                        fixed (b2 = &bs[(System.UIntPtr)column.uOffset])
                        {
                            i = BdpiSeries.SQLGetBlobLength(local, (IntPtr)b2, &k);
                        }
                        if (i == 0)
                        {
                            lBlobSize = k;
                        }
                    }
                    else
                    {
                        iInd = 1;
                    }
                }
            }
            */
            return i;
        }

        public virtual int GetBlob(short uColumn, ref byte[] buffer, ref int iInd, int iLength)
        {
            int i = 0;
            //byte[] bs = null;
            // Column column = null;
            //int j = 0;
            //void* local = (System.UIntPtr)0;
            //iInd = 0;
            /* i = FiSeriesComm.getColumn(uColumn, out column);
            if (i == 0 && column != null)
            {
                bs = FiSeriesComm.getRecordBuffer();
                local = FiSeriesComm.getDbHandle();
                if (bs != null)
                {
                    ref byte b1;

                    ref byte b2;

                    fixed (b1 = &bs[(System.UIntPtr)column.uNullOffset])
                    {
                        j = *((IntPtr)b1);
                    }
                    if (j != -1)
                    {
                        iInd = 0;
                        fixed (b2 = &bs[(System.UIntPtr)column.uOffset])
                        {
                            fixed (b3 = &buffer[0])
                            {
                                i = BdpiSeries.SQLGetBlob(local, (IntPtr)b2, (IntPtr)b3, iLength);
                            }
                        }
                    }
                    else
                    {
                        iInd = 1;
                    }
                }
            }
            */
            return i;
        }

        public virtual int GetVarBytes(short uColumn, ref byte[] buffer, ref int iInd, int iLength)
        {
            int i = 0;
            //byte[] bs = null;
            // Column column = null;
            //int j = 0;
            //iInd = 0;
            /* i = FiSeriesComm.getColumn(uColumn, out column);
            if (i == 0 && column != null)
            {
                bs = FiSeriesComm.getRecordBuffer();
                if (bs != null)
                {
                    ref byte b1;

                    ref byte b2;

                    fixed (b1 = &bs[(System.UIntPtr)column.uNullOffset])
                    {
                        j = *((IntPtr)b1);
                    }
                    if (j != -1)
                    {
                        iInd = 0;
                        fixed (b2 = &bs[(System.UIntPtr)column.uOffset])
                        {
                            fixed (b3 = &buffer[0])
                            {
                                i = BdpiSeries.SQLGetBytes((IntPtr)b2, (IntPtr)b3, column.uPhyType, j);
                            }
                        }
                    }
                    else
                    {
                        iInd = 1;
                    }
                }
            }
            */
            return i;
        }

    }

//----------------------------------------------------------------------
    public class iSeriesMetaData: ISQLMetaData
    {
        private string FCatalogName;
        private string FSchemaName;
        private string FDatabaseName;
        private string FDatabaseVersion;
        private BdpIsolation eTransactionIsoLevel;
        private bool bSupportsTransaction;
        private int iMaxObjectNameLength;
        private int iMaxColumnsInTable;
        private int iMaxColumnsInSelect;
        private int iMaxRowSize;
        private int iMaxSQLLength;
        private string FObjectQuoteChar;
        private string FSQLEscapeChar;
        private bool bProcSupportsCursor;
        private bool bProcSupportsCursors;
        private bool bSupportsTransactions;
        private string FPackageName;
        private string FObjectName;
        private string FQualifiedName;
        private string FQuotedObjectName;
        private string FObjectQuoteSuffix;
        private bool FQuoteObjects;
        private iSeriesConnection FiSeriesConn;
        private int MetHandle;

        public iSeriesMetaData(iSeriesConnection iSeriesConn)
        { FiSeriesConn = iSeriesConn;
          if (BdpiSeries.ConGetMetadata(FiSeriesConn.ConnHandle, out MetHandle)!=0)
            throw new BdpException("Metadata init failed");

          FCatalogName = "";
          FSchemaName = "";
          FDatabaseName = "";
          FDatabaseVersion = "";
          eTransactionIsoLevel = BdpIsolation.ReadCommitted;
          bSupportsTransaction = false;
          iMaxObjectNameLength = 0;
          iMaxColumnsInTable = 0;
          iMaxColumnsInSelect = 0;
          iMaxRowSize = 0;
          iMaxSQLLength = 0;
          FObjectQuoteChar = "";
          FSQLEscapeChar = "";
          bProcSupportsCursor = false;
          bProcSupportsCursors = false;
          bSupportsTransactions = false;
          FPackageName = "";
          FObjectName = "";
          FQualifiedName = "";
          FQuotedObjectName = "";
          FQuoteObjects = false;
          FObjectQuoteSuffix = "\"";
        }

        public virtual void SetProperty(MetaDataProps eMetaProp, object Value)
        { switch (eMetaProp) {
            case MetaDataProps.CatalogName:         FCatalogName  = (String)Value; return;
            case MetaDataProps.SchemaName:          FSchemaName   = (String)Value; return;
            case MetaDataProps.DatabaseName:        FDatabaseName = (String)Value; return;
            case MetaDataProps.TransactionIsoLevel: eTransactionIsoLevel = (BdpIsolation)Value; return;
            case MetaDataProps.PackageName:         FPackageName  = (String)Value; return;
            case MetaDataProps.ObjectName:          FObjectName   = (String)Value; return;
            case MetaDataProps.QuoteObjects:        FQuoteObjects = (Boolean)Value; return;
          }
        }

        public virtual void GetProperty(MetaDataProps eMetaProp, out object Value)
        {   string str3;
            StringBuilder stringBuilder2;
            string str4;

            switch (eMetaProp) {
            case MetaDataProps.CatalogName:          Value = FCatalogName; return;
            case MetaDataProps.SchemaName:           Value = FSchemaName;  return;
            case MetaDataProps.DatabaseName:         Value = FDatabaseName; return;
            case MetaDataProps.DatabaseVersion:      Value = FDatabaseVersion; return;
            case MetaDataProps.TransactionIsoLevel:  Value = eTransactionIsoLevel; return;
            case MetaDataProps.SupportsTransaction:  Value = bSupportsTransaction; return;
            case MetaDataProps.MaxObjectNameLength:  Value = iMaxObjectNameLength; return;
            case MetaDataProps.MaxColumnsInTable:    Value = iMaxColumnsInTable; return;
            case MetaDataProps.MaxColumnsInSelect:   Value = iMaxColumnsInSelect; return;
            case MetaDataProps.MaxRowSize:           Value = iMaxRowSize; return;
            case MetaDataProps.MaxSQLLength:         Value = iMaxSQLLength; return;
            case MetaDataProps.ObjectQuoteChar:      Value = FObjectQuoteChar; return;
            case MetaDataProps.SQLEscapeChar:        Value = FSQLEscapeChar; return;
            case MetaDataProps.ProcSupportsCursor:   Value = bProcSupportsCursor; return;
            case MetaDataProps.ProcSupportsCursors:  Value = bProcSupportsCursors; return;
            case MetaDataProps.SupportsTransactions: Value = bSupportsTransactions; return;
            case MetaDataProps.PackageName:          Value = FPackageName; return;
            case MetaDataProps.ObjectName:           Value = FObjectName; return;
            case MetaDataProps.QuoteObjects:         Value = FQuoteObjects; return;
            #if version1200
            #else
            case MetaDataProps.ObjectQuoteSuffix:    Value = FObjectQuoteSuffix; return;
            #endif
            case MetaDataProps.QualifiedName:
                string str1 = "\"";
                FQualifiedName = "";
                StringBuilder stringBuilder1 = new StringBuilder();
                string str2 = "";
                if (FCatalogName.Length > 0)
                {
                    str2 = FCatalogName.Trim(str1.ToCharArray());
                    stringBuilder1.Append(str2);
                    stringBuilder1.Append(".");
                }
                if (FSchemaName.Length > 0)
                {
                    str2 = FSchemaName.Trim(str1.ToCharArray());
                    stringBuilder1.Append(str2);
                    stringBuilder1.Append(".");
                }
                if (FObjectName.Length > 0)
                {
                    str2 = FObjectName.Trim(str1.ToCharArray());
                    stringBuilder1.Append(str2);
                }
                FQualifiedName = stringBuilder1.ToString();
                Value = FQualifiedName;
                return;

            case MetaDataProps.QuotedObjectName:
                str3 = "\"";
                FQuotedObjectName = "";
                stringBuilder2 = new StringBuilder();
                str4 = "";
                if (FCatalogName.Length > 0) {
                  str4 = FCatalogName.Trim(str3.ToCharArray());
                  stringBuilder2.Append("\"");
                  stringBuilder2.Append(str4);
                  stringBuilder2.Append("\"");
                  stringBuilder2.Append(".");
                }
            if (FSchemaName.Length > 0)
            {
                str4 = FSchemaName.Trim(str3.ToCharArray());
                stringBuilder2.Append("\"");
                stringBuilder2.Append(str4);
                stringBuilder2.Append("\"");
                stringBuilder2.Append(".");
            }
            if (FObjectName.Length > 0)
            {
                str4 = FObjectName.Trim(str3.ToCharArray());
                stringBuilder2.Append("\"");
                stringBuilder2.Append(str4);
                stringBuilder2.Append("\"");
            }
            FQuotedObjectName = stringBuilder2.ToString();
            Value = FQuotedObjectName;
            return;

            default:
                Value = null;
                return;
            }
        }

        public virtual DataTable GetObjectList(ObjectType eObj)
        {
            throw new BdpException("iSeries GetObjectList not yet implemented");
        }
#if version2000
  public virtual ISQLSchemaCreate GetSchemaCreate()
  { return new iSeriesSchemaCreate(FiSeriesConn);
  }
#endif


  public virtual DataTable GetTables(string szTableName, TableType eTable)
  { DataTable dataTable = BdpMetaDataHelper.CreateTableTable();
    int row = 0;
    int nulInd;
    StringBuilder sb = new StringBuilder(80);

    BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetOpenSchema(MetHandle, MetaDataType.Tables, FCatalogName, FSchemaName, szTableName, "", (int) eTable));
    while (BdpiSeries.MetNext(MetHandle) == 0) {
      row++;
      DataRow dataRow = dataTable.NewRow();
      dataRow["RecNo"] = row;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 2, sb, out nulInd)); if (nulInd==0) dataRow["CatalogName"] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 3, sb, out nulInd)); if (nulInd==0) dataRow["SchemaName" ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 4, sb, out nulInd)); if (nulInd==0) dataRow["TableName"  ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 5, sb, out nulInd));
      if (nulInd == 0)
        switch (sb.ToString()) {
          case "VIEW":         dataRow["TableType"] = 2; break;
          case "SYSTEM TABLE": dataRow["TableType"] = 4; break;
          case "SYNONYM":      dataRow["TableType"] = 8; break;
          default:             dataRow["TableType"] = 1; break; // TABLE
        }
      dataTable.Rows.Add(dataRow);
    }
    BdpiSeries.MetCloseSchema(MetHandle);
    return dataTable;
  }

  public virtual DataTable GetColumns(string szTableName, string szColumnName, ColumnType eCol)
  { DataTable dataTable = BdpMetaDataHelper.CreateColumnTable();
    int row = 0;
    int nulInd;
    int vl;
    short uType, uSubType;
    StringBuilder sb = new StringBuilder(80);

    BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetOpenSchema(MetHandle, MetaDataType.Columns, FCatalogName, FSchemaName, szTableName, szColumnName, (int) eCol));
    while (BdpiSeries.MetNext(MetHandle) == 0) {
      row++;
      DataRow dataRow = dataTable.NewRow();
      dataRow["RecNo"] = row;
      dataRow["ColumnType"] = 8;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 2, sb, out nulInd)); if (nulInd==0) dataRow["CatalogName"] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 3, sb, out nulInd)); if (nulInd==0) dataRow["SchemaName" ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 4, sb, out nulInd)); if (nulInd==0) dataRow["TableName"  ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 5, sb, out nulInd)); if (nulInd==0) dataRow["ColumnName" ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle, 6, out vl, out nulInd)); if (nulInd==0) dataRow["ColumnPosition"] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle,11, out vl, out nulInd)); if (nulInd==0) dataRow["ColumnLength"] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle,12, out vl, out nulInd)); if (nulInd==0) dataRow["ColumnPrecision"] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle,13, out vl, out nulInd)); if (nulInd==0) dataRow["ColumnScale"    ] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle,14, out vl, out nulInd)); if (nulInd==0) dataRow["ColumnNullable"] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 9, sb, out nulInd)); if (nulInd==0) dataRow["ColumnTypeName"] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetType  (MetHandle, out uType, out uSubType, out nulInd));
      if (nulInd==0) {
        dataRow["ColumnDataType"] = uType;
        dataRow["ColumnSubType"]  = uSubType;
      }
      dataTable.Rows.Add(dataRow);
    }
    BdpiSeries.MetCloseSchema(MetHandle);
    return dataTable;
  }

  public virtual DataTable GetIndices(string szTableName, IndexType uIndexType)
  { DataTable dataTable = BdpMetaDataHelper.CreateIndexTable();
    int row = 0;
    int nulInd;
    int vl;
    StringBuilder sb = new StringBuilder(80);

    if (uIndexType==0 || (uIndexType & IndexType.PrimaryKey) != 0) {
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetOpenSchema(MetHandle, MetaDataType.PrimaryKeys, FCatalogName, FSchemaName, szTableName, "", (int) IndexType.PrimaryKey ));
      while (BdpiSeries.MetNext(MetHandle) == 0) {
        row++;
        DataRow dataRow = dataTable.NewRow();
        dataRow["RecNo"] = row;
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 2, sb, out nulInd)); if (nulInd==0) dataRow["CatalogName"] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 3, sb, out nulInd)); if (nulInd==0) dataRow["SchemaName" ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 4, sb, out nulInd)); if (nulInd==0) dataRow["TableName"  ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 6, sb, out nulInd)); if (nulInd==0) dataRow["ColumnName" ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 8, sb, out nulInd)); if (nulInd==0) dataRow["PKeyName"   ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle, 7, out vl, out nulInd)); if (nulInd==0) dataRow["ColumnPosition"] = vl;
        dataRow["IndexType"] = IndexType.PrimaryKey;
        dataTable.Rows.Add(dataRow);
      }
      BdpiSeries.MetCloseSchema(MetHandle);
    }
    if (uIndexType == 0||(uIndexType & IndexType.Unique) != 0 || (uIndexType & IndexType.NonUnique) != 0) {
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetOpenSchema(MetHandle, MetaDataType.PrimaryKeys, FCatalogName, FSchemaName, szTableName, "", (int) IndexType.PrimaryKey ));
      while (BdpiSeries.MetNext(MetHandle) == 0) {
        row++;
        DataRow dataRow = dataTable.NewRow();
        dataRow["RecNo"] = row;
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 2, sb, out nulInd)); if (nulInd==0) dataRow["CatalogName"] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 3, sb, out nulInd)); if (nulInd==0) dataRow["SchemaName" ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 4, sb, out nulInd)); if (nulInd==0) dataRow["TableName"  ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 5, sb, out nulInd)); if (nulInd==0) dataRow["IndexName"  ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 6, sb, out nulInd)); if (nulInd==0) dataRow["ColumnName" ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 8, sb, out nulInd)); if (nulInd==0) dataRow["PKeyName"   ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle,10, sb, out nulInd)); if (nulInd==0) dataRow["SortOrder"  ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle,11, sb, out nulInd)); if (nulInd==0) dataRow["Filter"     ] = sb.ToString();
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle, 7, out vl, out nulInd)); if (nulInd==0) dataRow["ColumnPosition"] = vl;
        BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle, 9, out vl, out nulInd)); if (nulInd==0) dataRow["IndexType"] = vl;
        dataTable.Rows.Add(dataRow);
      }
      BdpiSeries.MetCloseSchema(MetHandle);
    }
    return dataTable;
  }

  public virtual DataTable GetProcedures(string szProcName, ProcedureType eProc)
  { DataTable dataTable = BdpMetaDataHelper.CreateProcedureTable();
    int row = 0;
    int nulInd;
    int vl;
    StringBuilder sb = new StringBuilder(80);

    BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetOpenSchema(MetHandle, MetaDataType.Procedures, FCatalogName, FSchemaName, szProcName, "", (int) eProc));
    while (BdpiSeries.MetNext(MetHandle) == 0) {
      row++;
      DataRow dataRow = dataTable.NewRow();
      dataRow["RecNo"] = row;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 2, sb, out nulInd)); if (nulInd==0) dataRow["CatalogName"] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 3, sb, out nulInd)); if (nulInd==0) dataRow["SchemaName" ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 4, sb, out nulInd)); if (nulInd==0) dataRow["ProcName"   ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle, 5, out vl, out nulInd)); if (nulInd==0) dataRow["ProcType"] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle, 6, out vl, out nulInd)); if (nulInd==0) vl=0; dataRow["InParams"] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle, 7, out vl, out nulInd)); if (nulInd==0) vl=0; dataRow["OutParams"] = vl;
      dataTable.Rows.Add(dataRow);
    }
    BdpiSeries.MetCloseSchema(MetHandle);
    return dataTable;
  }

  public virtual DataTable GetProcedureParams(string szProcName, string szParamName)
  { DataTable dataTable = BdpMetaDataHelper.CreateProcedureParamsTable();
    int row = 0;
    int nulInd;
    int vl;
    short uType, uSubType;
    StringBuilder sb = new StringBuilder(80);

    BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetOpenSchema(MetHandle, MetaDataType.ProcedureColumns, FCatalogName, FSchemaName, szProcName, szParamName, 0));
    while (BdpiSeries.MetNext(MetHandle) == 0) {
      row++;
      DataRow dataRow = dataTable.NewRow();
      dataRow["RecNo"] = row;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 2, sb, out nulInd)); if (nulInd==0) dataRow["CatalogName"] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 3, sb, out nulInd)); if (nulInd==0) dataRow["SchemaName" ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 4, sb, out nulInd)); if (nulInd==0) dataRow["ProcName"   ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 5, sb, out nulInd)); if (nulInd==0) dataRow["ParamName"  ] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetString(MetHandle, 9, sb, out nulInd)); if (nulInd==0) dataRow["ParamTypeName"] = sb.ToString();
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle, 6, out vl, out nulInd)); if (nulInd==0) dataRow["ParamPosition" ] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle, 7, out vl, out nulInd)); if (nulInd==0) dataRow["ParamType"     ] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle,11, out vl, out nulInd)); if (nulInd==0) dataRow["ParamLength"   ] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle,12, out vl, out nulInd)); if (nulInd==0) dataRow["ParamPrecision"] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle,13, out vl, out nulInd)); if (nulInd==0) dataRow["ParamScale"    ] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetInt32  (MetHandle,14, out vl, out nulInd)); if (nulInd==0) dataRow["ParamNullable"] = vl;
      BdpErrorCode.BdpCheck(FiSeriesConn, BdpiSeries.MetGetType  (MetHandle, out uType, out uSubType, out nulInd));
      if (nulInd==0) {
        dataRow["ParamDataType"] = uType;
        dataRow["ParamSubtype"]  = uSubType;
      }
      dataTable.Rows.Add(dataRow);
    }
    BdpiSeries.MetCloseSchema(MetHandle);
    return dataTable;
  }

  public virtual DataTable GetSchemaTable(IDataReader reader, IDbCommand command)
  { DataTable dataTable = BdpMetaDataHelper.CreateSchemaTable();
    string tablename = BdpMetaDataHelper.GetTableName(command.CommandText, command.CommandType).Replace("\"", null);
    string[] nameparts = tablename.Split('.');
    if (nameparts.Length==2) {
      FSchemaName = nameparts[0];
      tablename = nameparts[1];
    }
    FillSchemaTable(reader, tablename, dataTable);
    return dataTable;
  }

  private Type GetDataType(BdpType dbFieldType)
  { switch (dbFieldType) {
      case BdpType.String:    return Type.GetType("System.String");
      case BdpType.Boolean:   return Type.GetType("System.Boolean");
      case BdpType.Int16:     return Type.GetType("System.Int16");
      case BdpType.Int32:     return Type.GetType("System.Int32");
      case BdpType.Int64:     return Type.GetType("System.Int64");
      case BdpType.Float:     return Type.GetType("System.Single");
      case BdpType.Double:    return Type.GetType("System.Double");
      case BdpType.Decimal:   return Type.GetType("System.Decimal");
      case BdpType.Date:
      case BdpType.Time:
      case BdpType.DateTime:  return Type.GetType("System.DateTime");
      case BdpType.Bytes:
      case BdpType.VarBytes:
      case BdpType.Blob:      return Type.GetType("System.Byte[]");
      default:                return typeof(DBNull);
    }
  }

  private void FillSchemaTable(IDataReader reader, string tableName, DataTable tbl)
  { foreach (DataRow srcRow in GetColumns(tableName, "", (ColumnType)0).Rows)
      if (BdpMetaDataHelper.IsProjectedColumn(reader, srcRow["ColumnName"].ToString())!= false) {
        DataRow dstRow = tbl.NewRow();
        BdpType DataType           = (BdpType) (short) srcRow["ColumnDataType"];
        dstRow["ColumnName"]       = srcRow["ColumnName"];
        dstRow["ColumnOrdinal"]    = srcRow["ColumnPosition"];
        dstRow["ColumnSize"]       = srcRow["ColumnLength"];
        dstRow["NumericPrecision"] = srcRow["ColumnPrecision"];
        dstRow["NumericScale"]     = srcRow["ColumnScale"];
        dstRow["DataType"]         = GetDataType(DataType);
        dstRow["ProviderType"]     = DataType;
        dstRow["IsLong"]           = (DataType == BdpType.Blob);
        dstRow["AllowDBNull"]      = (short) srcRow["ColumnNullable"];
        dstRow["IsReadOnly"]       = 0;
        dstRow["IsRowVersion"]     = 0;
        dstRow["IsUnique"]         = 0;
        dstRow["IsKeyColumn"]      = 0;
        dstRow["BaseCatalogName"]  = null; // srcRow["CatalogName"];
        dstRow["BaseSchemaName"]   = srcRow["SchemaName"];
        dstRow["BaseTableName"]    = srcRow["TableName"];
        dstRow["BaseColumnName"]   = srcRow["ColumnName"];
        dstRow["ProviderSubType"]  = srcRow["ColumnSubType"];

        tbl.Rows.Add(dstRow);
    }

    foreach (DataRow srcRow in GetIndices(tableName, IndexType.PrimaryKey|IndexType.Unique).Rows) {
      DataRow[] dataRows = tbl.Select("ColumnName=\'"+srcRow["ColumnName"]+"\'");
      switch ((short) srcRow["IndexType"]) {
        case 4:
        case 6:
          dataRows[0].BeginEdit();
          dataRows[0]["IsKeyColumn"] = 1;
          dataRows[0].EndEdit();
          break;
        case 2:
          dataRows[0].BeginEdit();
          dataRows[0]["IsUnique"] = 1;
          dataRows[0].EndEdit();
          break;
      }
    }
    tbl.AcceptChanges();
  }

}


public class iSeriesResolver: ISQLResolver
{ private iSeriesConnection FiSeriesConn;
  private string FQuotePrefix;
  private string FQuoteSuffix;
  private string[] FReadOnly;
  private string[] FExcludeFilter;
  private DataRow FRow;

  public iSeriesResolver(iSeriesConnection iSeriesConn)
  { FiSeriesConn = iSeriesConn; }

  public virtual string GetInsertSQL(IDbConnection Conn, IDbCommand Command, DataRowCollection columns, string TableName)
  { return "INSERT INTO " + TableName +
           " (" + BdpResolverHelper.GenerateColList(this, columns, null, ColumnListType.NameOnly, false) +
           ") VALUES (" + BdpResolverHelper.GenerateColList(this, columns, Command, ColumnListType.ParamQuestion, false) + ")";
  }

  public virtual string GetUpdateSQL(IDbConnection Conn, IDbCommand Command, DataRowCollection columns, string TableName, BdpUpdateMode UpdateMode)
  { string res = "UPDATE " + TableName + " SET " + BdpResolverHelper.GenerateColList(this, columns, Command, ColumnListType.NameEqQuestion, false, UpdateMode);
    if (BdpResolverHelper.IsSearchable(columns, UpdateMode))
      return res + " WHERE " + BdpResolverHelper.GenerateColList(this, columns, Command, ColumnListType.NameEqQuestion, true, UpdateMode);
    else
      return res;
  }

  public virtual string GetDeleteSQL(IDbConnection Conn, IDbCommand Command, DataRowCollection columns, string TableName, BdpUpdateMode UpdateMode)
  { string res = "DELETE FROM " + TableName;
    if (BdpResolverHelper.IsSearchable(columns, UpdateMode))
      return res + " WHERE " + BdpResolverHelper.GenerateColList(this, columns, Command, ColumnListType.NameEqQuestion, true, UpdateMode);
    else
      return res;
  }

  public virtual string GetSelectSQL(IDbConnection Conn, DataRowCollection columns, string TableName)
  { return "SELECT " + BdpResolverHelper.GenerateColList(this, columns, null, ColumnListType.NameOnly, false) + " FROM " + TableName;
  }

  public string QuotePrefix
  { get {return FQuotePrefix;}
    set {FQuotePrefix = value;}
  }

  public string QuoteSuffix
  { get {return FQuoteSuffix;}
    set {FQuoteSuffix = value;}
  }

  public string[] ReadOnly
  { get {return FReadOnly;}
    set {FReadOnly = value;}
  }

  public string[] ExcludeFilter
  { get {return FExcludeFilter;}
    set {FExcludeFilter = value;}
  }

  public DataRow Row
  { get {return FRow;}
    set {FRow = value;}
  }

}

#if version2000
public class iSeriesSchemaCreate: ISQLSchemaCreate
{ private iSeriesConnection FiSeriesConn;
  private string FSchemaName;
  private bool FBatchExecute;
  private DataTable FDataTypes;

  public iSeriesSchemaCreate(iSeriesConnection conn)
  { FiSeriesConn = conn;
    FBatchExecute = false;
    FSchemaName = "";
    FDataTypes = BdpMetaDataHelper.CreateTypesTable();
    AddRows(FDataTypes);
  }

  public bool BatchExecute
  { get {return FBatchExecute;}
  }

  public string SchemaName
  { get {return FSchemaName;}
    set {FSchemaName = value;}
  }

  public void CreateObject(ObjectType ObjType, string ObjectName, string BaseObject, BdpColumnCollection BdpColumns)
  { if (ObjType == ObjectType.Table)
      ExecuteDDL(GenerateCreateTable(ObjectName, BdpColumns));
  }

  public void CreateObject(ObjectType ObjType, string ObjectName, string BaseObject, DataTable dataTable)
  { if (ObjType == ObjectType.Table)
      ExecuteDDL(ProcessTable(ObjectName, dataTable));
  }

  public void DropObject(ObjectType ObjType, string ObjectName, string BaseObject)
  { if (ObjType==ObjectType.Table)     ExecuteDDL(" DROP "+"TABLE "+ObjectName);
    if (ObjType==ObjectType.View)      ExecuteDDL(" DROP "+"VIEW "+ObjectName);
    if (ObjType==ObjectType.Procedure) ExecuteDDL(" DROP "+"PROCEDURE "+ObjectName);
  }

  public DataTable GetDataTypes()
  { return FDataTypes;
  }

  public string GetDDL(ObjectType ObjType, string ObjectName, string BaseObject, BdpColumnCollection BdpColumns)
  { if (ObjType==ObjectType.Table) return this.GenerateCreateTable(ObjectName, BdpColumns);
    if (ObjType==ObjectType.View)  return this.GenerateCreateView(ObjectName,  BaseObject, BdpColumns);
    if (ObjType==ObjectType.Index) return this.GenerateCreateIndex(ObjectName, BaseObject, BdpColumns);
    return "";
  }

  public string[] GetDDL(ObjectType ObjType, string ObjectName, string BaseObject, DataTable dataTable)
  { if (ObjType == ObjectType.Table)
      return ProcessTable(ObjectName, dataTable).Split('\n');
    else
      return null;
  }

  private void AddRows(DataTable dataTable)
  { string[]  stFldTypes =   {"CHAR",         "VARCHAR",      "INTEGER",     "SMALLINT",    "BIGINT",      "REAL",        "DOUBLE",      "NUMERIC",       "DECIMAL",       "DATE",       "TIME",       "TIMESTAMP",      "BLOB",       "CLOB",       "CHAR () FOR BIT DATA", "VARCHAR () FOR BIT DATA" };
    BdpType[] typeMap =      {BdpType.String, BdpType.String, BdpType.Int32, BdpType.Int16, BdpType.Int64, BdpType.Float, BdpType.Float, BdpType.Decimal, BdpType.Decimal, BdpType.Date, BdpType.Time, BdpType.DateTime, BdpType.Blob, BdpType.Blob, BdpType.Bytes,          BdpType.VarBytes};
    BdpType[] subTypeMap =   {BdpType.stFixed,0,              0,             0,             0,             0,             0,             0,               0,               0,            0,            0,                BdpType.stBinary, BdpType.stMemo, 0,                0 };
    int[]     precisionMap = {255,            32767,          0,             0,             0,             0,             0,             18,              18,              0,            0,            0,                0,            0,            255,                    32767};
    for (int i = 0; (i < stFldTypes.Length); i += 1)
    { DataRow row = dataTable.NewRow();
      row["RecNo"]         = i + 1;
      row["TypeName"]      = stFldTypes[i];
      row["BdpType"]       = typeMap[i];
      row["BdpSubType"]    = subTypeMap[i];
      row["MaxPrecision"]  = precisionMap[i];
      row["MaxScale"]      = 0;
      row["NeedPrecision"] = 0;
      row["NeedScale"]     = 0;
      row["Searchable"]    = 1;
      if (typeMap[i] == BdpType.String)
        row["NeedPrecision"] = 1;
      if (typeMap[i] == BdpType.Decimal)
      { row["MaxScale"]      = 18;
        row["NeedPrecision"] = 1;
        row["NeedScale"]     = 1;
      }
      dataTable.Rows.Add(row);
    }
  }

  private void ExecuteDDL(string ddl)
  { ISQLCursor cursor;
    short num = 0;
    iSeriesCommand cmd = (iSeriesCommand) FiSeriesConn.GetSQLCommand();
    BdpErrorCode.BdpCheck(cmd, cmd.Prepare(ddl, 0));
    BdpErrorCode.BdpCheck(cmd, cmd.Execute(out cursor, ref num));
    cmd.Close();
    cmd.Release();
  }

  private string GenAddedRow(string ObjectName, DataRow row, bool bFirst)
  { string addrowcmd = " ADD " + "COLUMN " + GenerateCurrentColumn(row);
    if (bFirst)
      return "\n" + "ALTER " + "TABLE " + ObjectName + " " + addrowcmd;
    else
      return addrowcmd;
  }

  private string GenDeletedRow(string ObjectName, DataRow row, bool bFirst)
  { string droprowcmd = " DROP " + row["NAME", DataRowVersion.Original];
    if (bFirst)
      return "\n" + "ALTER " + "TABLE " + ObjectName + " " + droprowcmd;
    else
      return ", " + droprowcmd;
  }

  private string GenModifiedRow(string ObjectName, DataRow row, bool bFirst)
  { string modrowcmd = " ALTER " + GenerateModifiedColumn(row);
    if (this.IsRowDataChanged(row) && this.IsColumnNameChanged(row))
      throw new BdpException("Columns cannot be renamed");
    if (bFirst)
      return "\n" + "ALTER "+ "TABLE " + ObjectName + " " + modrowcmd;
    else
      return modrowcmd;
  }

  private string GenerateAddedColumns(string ObjectName, DataTable dataTable)
  { DataRowCollection drc = dataTable.Rows;
    bool bFirst = false;
    StringBuilder cmd = new StringBuilder();
    if (!HasChanges(drc))
      return "";
    for (int i = 0; (i < drc.Count); i += 1)
      if (drc[i].RowState == DataRowState.Added)
      { if (bFirst)
          cmd.Append(", ");
        else
          cmd.Append(" ADD ");
        cmd.Append(GenerateCurrentColumn(drc[i]));
      }
    return "ALTER " + "TABLE " + ObjectName + " " + cmd.ToString();
  }

  private string GenerateAlterTable(string ObjectName, DataTable dataTable)
  { DataRowCollection drc = dataTable.Rows;
    DataRowState lastState = DataRowState.Unchanged;

    if (!HasChanges(drc))
      return "";

    StringBuilder cmd = new StringBuilder();
    for (int i=0; i < drc.Count; i++)
    { if (drc[i].RowState==DataRowState.Deleted)
        throw new BdpException("DB2/400 doesn\'t allow to drop columns");

      if (drc[i].RowState == DataRowState.Added)
      { cmd.Append(GenAddedRow(ObjectName, drc[i], lastState!=DataRowState.Added));
        lastState = DataRowState.Added;
      }

      if ((drc[i].RowState == DataRowState.Modified) && IsRowDataChanged(drc[i]))
      { cmd.Append(GenModifiedRow(ObjectName, drc[i], lastState!=DataRowState.Modified));
        lastState = DataRowState.Modified;
      }
    }
    return cmd.ToString();
  }

  private string GenerateCreateIndex(string ObjectName, string BaseObject, BdpColumnCollection columns)
  { StringBuilder cmd = new StringBuilder();
    for (int i = 0; i<columns.Count; i++)
    { if (i>0)
        cmd.Append(", ");
      cmd.Append(columns[i].ColumnName);
    }
    return "CREATE " + "INDEX " + ObjectName + " ON " + BaseObject + " ( " + cmd.ToString() + " ) ";
  }

  private string GenerateCreateTable(string ObjectName, BdpColumnCollection columns)
  { StringBuilder cmd = new StringBuilder();
    for (int i = 0; i<columns.Count; i++)
    { if (i>0)
        cmd.Append(", ");
      cmd.Append(columns[i].ColumnName);
      cmd.Append(" ");
      cmd.Append(columns[i].SQLType);
      if (columns[i].BdpType==BdpType.String)
      { cmd.Append("(");
        cmd.Append(columns[i].Precision);
        cmd.Append(")");
      } else
      if (columns[i].BdpType==BdpType.Decimal)
      { cmd.Append("(");
        cmd.Append(columns[i].Precision);
        cmd.Append(", ");
        cmd.Append(columns[i].Scale);
        cmd.Append(")");
      }
      if (!columns[i].IsNullable)
        cmd.Append(" NOT NULL ");
    }
    return "CREATE " + "TABLE " + ObjectName + " ( " + cmd.ToString() + " ) ";
  }

  private string GenerateCreateTable(string ObjectName, DataTable dataTable)
  { StringBuilder cmd = new StringBuilder();
    DataRowCollection drc = dataTable.Rows;
    for (int i = 0; i<drc.Count; i++)
    { if (i>0)
        cmd.Append(", ");
      cmd.Append(GenerateCurrentColumn(drc[i]));
    }
    return "CREATE " + "TABLE " + ObjectName + " ( " + cmd.ToString() + " ) ";
  }

  private string GenerateCreateView(string ObjectName, string BaseObject, BdpColumnCollection columns)
  { StringBuilder cmd = new StringBuilder();
    for (int i = 0; i<columns.Count; i++)
    { if (i>0)
        cmd.Append(", ");
      cmd.Append(columns[i].ColumnName);
    }
    return "CREATE " + "VIEW " + ObjectName + " AS " + " SELECT " + cmd.ToString() + " FROM " + BaseObject;
  }

  private string GenerateCurrentColumn(DataRow row)
  { string name = row["NAME", DataRowVersion.Current].ToString().Trim();
    if (name.Length>0)
    { //if (char.IsLetter(name.chars[0]))
        return row["NAME", DataRowVersion.Current] + " " + GenerateDataType(row) + GenerateNotNull(row);
      //else
        //throw new BdpException("Column name should start with a character");
    } else
      throw new BdpException("Column name cannot be empty");
  }

  private string GenerateDataType(DataRow row)
  { bool bitData = false;
    StringBuilder cmd = new StringBuilder();
    DataRow foundRow = null;
    foreach (DataRow curRow in FDataTypes.Rows)
    { if ((string) curRow["TYPENAME"] == (string) row["DATATYPE", DataRowVersion.Current])
        foundRow = curRow;
    }

    if (foundRow == null)
      throw new BdpException("DataType " +  row["DATATYPE", DataRowVersion.Current] + " not found");

    if ((string) row["DATATYPE", DataRowVersion.Current] == "CHAR () FOR BIT DATA")
    { bitData = true;
      cmd.Append("CHAR");
    }
    else
    { if ((string) row["DATATYPE", DataRowVersion.Current] == "VARCHAR () FOR BIT DATA")
      { bitData = true;
        cmd.Append("VARCHAR");
      }
      else
        cmd.Append(row["DATATYPE", DataRowVersion.Current]);
    }

    if ((int) foundRow["MAXPRECISION"]!= 0)
    { cmd.Append("(");
      cmd.Append(row["PRECISION", DataRowVersion.Current]);
      if ((int) foundRow["MAXSCALE"] != 0)
      { cmd.Append(",");
        cmd.Append(row["SCALE", DataRowVersion.Current]);
      }
      cmd.Append(")");
    }
    if (bitData)
      cmd.Append(" FOR BIT DATA ");

    return cmd.ToString();
  }


  private string GenerateModifiedColumn(DataRow row)
  { if (this.IsPrecisionScaleChanged(row) || this.IsDataTypeChanged(row))
      return " COLUMN " + row["NAME", DataRowVersion.Original] + " SET " + "DATA TYPE" + " " + GenerateDataType(row);
    else
      return "";
  }

  private string GenerateNotNull(DataRow row)
  { if ((bool) row["NULLABLE", DataRowVersion.Current])
      return " NOT NULL ";
    else
      return "";
  }

  private bool HasChanges(DataRowCollection rows)
  { for (int i = 0; (i < rows.Count); i += 1)
    { if ( (rows[i].RowState == DataRowState.Added)
        || (rows[i].RowState == DataRowState.Deleted)
        || ((rows[i].RowState == DataRowState.Modified) && this.IsRowDataChanged(rows[i])) )
        return true;
    }
    return false;
  }

  private bool IsColumnNameChanged(DataRow row)
  { return ((string) row["NAME", DataRowVersion.Current] != (string) row["NAME", DataRowVersion.Original]);
  }

  private bool IsDataTypeChanged(DataRow row)
  { if ((string) row["DATATYPE", DataRowVersion.Current] != (string) row["DATATYPE", DataRowVersion.Original])
      throw new BdpException("DB2/400 doesn\'t allow column type changes. Only VARCHAR precision can be changed.");
    return false;
  }

  private bool IsPrecisionScaleChanged(DataRow row)
  { return (((int) row["PRECISION", DataRowVersion.Current] != (int) row["PRECISION", DataRowVersion.Original])
         || ((int) row["SCALE", DataRowVersion.Current]     != (int) row["SCALE", DataRowVersion.Original]));
  }

  private bool IsRowDataChanged(DataRow row)
  { return ((this.IsPrecisionScaleChanged(row) || this.IsDataTypeChanged(row)) || this.IsColumnNameChanged(row));
  }

  private string ProcessTable(string ObjectName, DataTable dataTable)
  { if (SC.IsNewTable(dataTable))
      return this.GenerateCreateTable(ObjectName, dataTable);
    if (SC.IsAllRowsDeleted(dataTable))
      return " DROP TABLE " + ObjectName;
    return this.GenerateAlterTable(ObjectName, dataTable);
  }

}
#endif


}

